/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Optional;

public final class SecurityInformationBuildItem
extends MultiBuildItem {
    private final SecurityModel securityModel;
    private final Optional<OpenIDConnectInformation> openIDConnectInformation;

    public static SecurityInformationBuildItem BASIC() {
        return new SecurityInformationBuildItem(SecurityModel.basic, Optional.empty());
    }

    public static SecurityInformationBuildItem JWT() {
        return new SecurityInformationBuildItem(SecurityModel.jwt, Optional.empty());
    }

    public static SecurityInformationBuildItem OAUTH2() {
        return new SecurityInformationBuildItem(SecurityModel.oauth2, Optional.empty());
    }

    public static SecurityInformationBuildItem OPENIDCONNECT(String urlConfigKey) {
        return new SecurityInformationBuildItem(SecurityModel.oidc, Optional.of(new OpenIDConnectInformation(urlConfigKey)));
    }

    public SecurityInformationBuildItem(SecurityModel securityModel, Optional<OpenIDConnectInformation> openIDConnectInformation) {
        this.securityModel = securityModel;
        this.openIDConnectInformation = openIDConnectInformation;
    }

    public SecurityModel getSecurityModel() {
        return this.securityModel;
    }

    public Optional<OpenIDConnectInformation> getOpenIDConnectInformation() {
        return this.openIDConnectInformation;
    }

    public static enum SecurityModel {
        basic,
        jwt,
        oauth2,
        oidc;

    }

    public static class OpenIDConnectInformation {
        private final String urlConfigKey;

        public OpenIDConnectInformation(String urlConfigKey) {
            this.urlConfigKey = urlConfigKey;
        }

        public String getUrlConfigKey() {
            return this.urlConfigKey;
        }
    }
}

