/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.util.List;
import java.util.Optional;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.issuance.OffsetTimeProvider;
import org.keycloak.protocol.oid4vc.issuance.signing.LDSigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningProperties;
import org.keycloak.protocol.oid4vc.issuance.signing.VCSigningServiceProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class LDSigningServiceProviderFactory
implements VCSigningServiceProviderFactory {
    public static final String SUPPORTED_FORMAT = "ldp_vc";
    private static final String HELP_TEXT = "Issues Verifiable Credentials in the W3C Data Model, using Linked-Data Proofs. See https://www.w3.org/TR/vc-data-model/";

    public VerifiableCredentialsSigningService create(KeycloakSession session, ComponentModel model) {
        String keyId = model.get(SigningProperties.KEY_ID.getKey());
        String proofType = model.get(SigningProperties.PROOF_TYPE.getKey());
        String algorithmType = model.get(SigningProperties.ALGORITHM_TYPE.getKey());
        Optional<String> kid = Optional.ofNullable(model.get(SigningProperties.KID_HEADER.getKey()));
        return new LDSigningService(session, keyId, algorithmType, proofType, new OffsetTimeProvider(), kid);
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return VCSigningServiceProviderFactory.configurationBuilder().property(SigningProperties.ALGORITHM_TYPE.asConfigProperty()).property(SigningProperties.PROOF_TYPE.asConfigProperty()).property(SigningProperties.KID_HEADER.asConfigProperty()).build();
    }

    public String getId() {
        return SUPPORTED_FORMAT.toString();
    }

    @Override
    public void validateSpecificConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkRequired(SigningProperties.ALGORITHM_TYPE.asConfigProperty()).checkRequired(SigningProperties.PROOF_TYPE.asConfigProperty());
    }

    @Override
    public String supportedFormat() {
        return SUPPORTED_FORMAT;
    }
}

