/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import org.jboss.logging.Logger;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.JwtCredentialBody;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningServiceException;

public class JwtSigningService
extends SigningService<String> {
    private static final Logger LOGGER = Logger.getLogger(JwtSigningService.class);
    private final SignatureSignerContext signatureSignerContext;

    public JwtSigningService(KeycloakSession keycloakSession, String keyId, String algorithmType) {
        super(keycloakSession, keyId, "jwt_vc", algorithmType);
        KeyWrapper signingKey = this.getKey(keyId, algorithmType);
        if (signingKey == null) {
            throw new SigningServiceException(String.format("No key for id %s and algorithm %s available.", keyId, algorithmType));
        }
        SignatureProvider signatureProvider = (SignatureProvider)keycloakSession.getProvider(SignatureProvider.class, algorithmType);
        this.signatureSignerContext = signatureProvider.signer(signingKey);
        LOGGER.debugf("Successfully initiated the JWT Signing Service with algorithm %s.", (Object)algorithmType);
    }

    @Override
    public String signCredential(VCIssuanceContext vcIssuanceContext) {
        LOGGER.debugf("Sign credentials to jwt-vc format.", new Object[0]);
        CredentialBody credentialBody = vcIssuanceContext.getCredentialBody();
        if (!(credentialBody instanceof JwtCredentialBody)) {
            throw new VCIssuerException("Credential body unexpectedly not of type JwtCredentialBody");
        }
        JwtCredentialBody jwtCredentialBody = (JwtCredentialBody)credentialBody;
        return jwtCredentialBody.sign(this.signatureSignerContext);
    }
}

